#!/bin/sh

CLST_PAGE_MAIN_MENU_RESULT_MSG=""
CLST_PAGE_MAIN_MENU_RESULT_OK=0
CLST_PAGE_MAIN_MENU_RESULT_ERROR=1

CLST_PAGE_MAIN_MENU_RESULT_CODE=${CLST_PAGE_MAIN_MENU_RESULT_ERROR}
CLST_PAGE_MAIN_MENU_RESULT_ROLLING=0


enter_switch_to_ms() {
    ENTER_SWITCH_TO_MS_MSG=""
    
    . ./clst_page_verify_switch_to_mst.sh

    local switch_to_ms_pages_array="
        clst_page_verify_switch_to_mst
    "

	pages_roller "${switch_to_ms_pages_array}"
    case "${PAGES_ROLLER_RESULT_CODE}" in
    
        "${PAGES_ROLLER_RESULT_OK}" )
            ENTER_SWITCH_TO_MS_MSG=""
            return 0
            ;;
            
        "${PAGES_ROLLER_RESULT_ERROR}" )
            ENTER_SWITCH_TO_MS_MSG="${PAGES_ROLLER_RESULT_MSG}"
            return 1
            ;;
            
        * )
            ENTER_SWITCH_TO_MS_MSG=""
            return 1
            ;;
    esac
}

enter_shutdown() {
    . ./clst_page_verify_shutdown.sh
    
    local shutdown_pages_array="
        clst_page_verify_shutdown
    "

	pages_roller "${shutdown_pages_array}"
    case "${PAGES_ROLLER_RESULT_CODE}" in
    
        "${PAGES_ROLLER_RESULT_OK}" )
            CLST_PAGE_MAIN_MENU_RESULT_CODE="${DPLY_MODE_RESULT_OK}"
            ;;
            
        "${PAGES_ROLLER_RESULT_ERROR}" )
            DPLY_MODE_RESULT_CODE="${DPLY_MODE_RESULT_ERROR}"
            ;;
            
        * )
            ;;
    esac
}

clst_page_main_menu() {
	debug_print 'in function "clst_page_main_menu"'
    
    local menu_list="1 \"${CLST_PAGE_MAIN_MENU_ITEM1}\" 2 \"${CLST_PAGE_MAIN_MENU_ITEM2}\""

    tp_menu_ok \
        "${CLST_PAGE_MAIN_MENU_TITLE}" \
        "${CLST_PAGE_MAIN_MENU_TEXT}" \
        "${CLST_PAGE_MAIN_MENU_LABEL_OK}" \
        "${menu_list}"
    debug_print "${0}" "${LINENO}" "UserChoose: ${TP_MENU_OK_RESULT_SELECT}"    
    
    
    case "${TP_MENU_OK_RESULT_CODE}" in
    
        "${TP_MENU_OK_RESULT_CANCEL}" )
            CLST_PAGE_MAIN_MENU_RESULT_CODE=$CLST_PAGE_MAIN_MENU_RESULT_OK
            CLST_PAGE_MAIN_MENU_RESULT_ROLLING=-1
            CLST_PAGE_MAIN_MENU_RESULT_MSG=""
            return
            ;;
            
        "${TP_MENU_OK_RESULT_OK}" )
            ;;
            
        * )
            CLST_PAGE_MAIN_MENU_RESULT_CODE=$CLST_PAGE_MAIN_MENU_RESULT_ERROR
            CLST_PAGE_MAIN_MENU_RESULT_ROLLING=-1
            CLST_PAGE_MAIN_MENU_RESULT_MSG="${CLST_PAGE_MAIN_MENU_ERROR_UNKNOWN}"
            return
            ;;
    esac
    
    
    case "${TP_MENU_OK_RESULT_SELECT}" in
        1 )
            local is_switchable=`dtascfg "${DTASCFG_XML_FILE}" get cli master_switchable`
            debug_print "is_switchable is ${is_switchable}"
            if [ ${is_switchable} == 1 ] ; then
               enter_switch_to_ms
            else
               warning "${CLST_PAGE_VERIFY_SWITCH_TO_MST_IS_NOT_SWITCHABLE}"
            fi

            CLST_PAGE_MAIN_MENU_RESULT_CODE=$CLST_PAGE_MAIN_MENU_RESULT_OK
            CLST_PAGE_MAIN_MENU_RESULT_ROLLING=1
            CLST_PAGE_MAIN_MENU_RESULT_MSG=""
            ;;
        2 )
            enter_shutdown
            ;;
        * )
            CLST_PAGE_MAIN_MENU_RESULT_CODE=$CLST_PAGE_MAIN_MENU_RESULT_ERROR
            CLST_PAGE_MAIN_MENU_RESULT_ROLLING=-1
            CLST_PAGE_MAIN_MENU_RESULT_MSG="${CLST_PAGE_MAIN_MENU_ERROR_UNKNOWN}"
            return
            ;;
    esac
    
    CLST_PAGE_MAIN_MENU_RESULT_CODE=$CLST_PAGE_MAIN_MENU_RESULT_OK
    CLST_PAGE_MAIN_MENU_RESULT_ROLLING=1
    CLST_PAGE_MAIN_MENU_RESULT_MSG=""
}
